BuyedMilicias = {}
--
function setMilitia2(sector, slot, force, num)
 --log("!setMilitia2", sector, slot, force, num)
 setMilitia(sector, slot, force, num)
 if (num > 0 or BuyedMilicias[sector]==nil) then
  
 else
  ----------------------------------------------------------------------
  local upgrade = BuyedMilicias[sector][slot]
  if(isValid(upgrade)) then
    --log("!setMilitia2", "eventUpgradeSell", upgrade)
    eventUpgradeSell(sector, upgrade)
    onUpgradeDestroy(sector, upgrade)
  end
 end
end
--
function buyMilitia(sector, upgrade)
	local slot = 0
	
	for count = 1, 4, 1 do
		local mt, mc = getMilitia(sector, count)
		if (mc == 0) then
			slot = count
			break
		end
	end
	
	if (slot > 0) then
		setMilitia(sector, slot, Upgrades[upgrade].militia, 5)
		if (nil==BuyedMilicias[sector]) then
			BuyedMilicias[sector] = {}
		end
		BuyedMilicias[sector][slot] = upgrade
		setGVAR(upgrade.."_slot", slot)
	end
end
--
MilitiaTemplates = 
{
	militia_butsi_squad_1 =
	{
		sector		= "roadblock",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	BUTSI,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= {{ force = BUTSI, value = 0.8 * Reputation.MAX, condition = MORE_OR_EQUAL }}
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_butsi_squad_2 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	BUTSI,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_butsi_squad_1"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_butsi_squad_3 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	BUTSI,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_butsi_squad_2"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_butsi_squad_4 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	BUTSI,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_butsi_squad_3"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s) 
--					buyMilitia(s, u)
--				end,
--		onSell = function(s) 
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_corp_squad_1 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	CORP,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= {{ force = CORP, value = 0.5 * Reputation.MAX, condition = MORE_OR_EQUAL }}
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_corp_squad_2 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	CORP,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_corp_squad_1"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_corp_squad_3 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	CORP,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_corp_squad_2"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_corp_squad_4 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	CORP,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_corp_squad_3"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_army_squad_1 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	ARMY,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= {{ force = ARMY, value = 0.8 * Reputation.MAX, condition = MORE_OR_EQUAL }}
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_army_squad_2 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	ARMY,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_army_squad_1"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_army_squad_3 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	ARMY,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_army_squad_2"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_army_squad_4 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	ARMY,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_army_squad_3"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_marauders_squad_1 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	MARAUDERS,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= {{ force = MARAUDERS, value = 0.8 * Reputation.MAX, condition = MORE_OR_EQUAL }}
		},
		bonus		= 100,
		reputation_bonus = { 
								{ force = UN, 			value = Reputation.Penalty.SMALL  },
								{ force = BUTSI, 		value = Reputation.Penalty.TINY },
								{ force = MARAUDERS,	value = Reputation.Bonus.SMALL  },
								{ force = CIVILIANS, 	value = Reputation.Penalty.SMALL   }
							},
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_marauders_squad_2 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	MARAUDERS,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_marauders_squad_1"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 100,
		reputation_bonus = { 
								{ force = UN, 			value = Reputation.Penalty.TINY  },
								{ force = BUTSI, 		value = Reputation.Penalty.TINY },
								{ force = MARAUDERS,	value = Reputation.Bonus.SMALL  },
								{ force = CIVILIANS, 	value = Reputation.Penalty.TINY   }
							},
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_marauders_squad_3 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	MARAUDERS,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_marauders_squad_2"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 50,
		reputation_bonus = { 
								{ force = UN, 			value = Reputation.Penalty.TINY  },
								{ force = MARAUDERS,	value = Reputation.Bonus.TINY  },
								{ force = CIVILIANS, 	value = Reputation.Penalty.TINY   }
							},
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	},
	militia_marauders_squad_4 =
	{
		sector		= "_any_",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	MARAUDERS,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= {"militia_marauders_squad_3"},
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 50,
		reputation_bonus = { 
								{ force = MARAUDERS,	value = Reputation.Bonus.TINY  },
								{ force = CIVILIANS, 	value = Reputation.Penalty.TINY   }
							},
--		onBuy = function(s, u)
--					buyMilitia(s, u)
--				end,
--		onSell = function(s, u)
--					setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--				end
	}
}
--
Upgrades = {}
--
Upgrades	=	
{
----------------------------------------------------------------
--TRAINSTATION
----------------------------------------------------------------
	trainstation_office =
	{
		sector		= "trainstation",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	trainstation_logistic_center =
	{
		sector		= "trainstation",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= {	"port", "coastal_city" },
			Upgrades	= { "coastal_city_transport_net" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	trainstation_train =
	{
		sector		= "trainstation",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	trainstation_repair_train =
	{
		sector		= "trainstation",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 250,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	trainstation_repair_depo =
	{
		sector		= "trainstation",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--AIRPORT
----------------------------------------------------------------
	airport_com_terminal	=	
	{
		sector		= "airport",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	airport_bus_station	=	
	{
		sector		= "airport",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= {	"port", "coastal_city" },
			Upgrades	= { "coastal_city_transport_net" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--PALACE
----------------------------------------------------------------
	palace_museum	=	
	{
		sector		= "palace",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--DAM
----------------------------------------------------------------
	dam_dynamo_1	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1750,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	dam_dynamo_2	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "dam_dynamo_1" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	dam_dynamo_3	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "dam_dynamo_2" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1250,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	dam_road	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "port", "coastal_city" },
			Upgrades	= { "coastal_city_transport_net" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	dam_tourism	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	dam_shop	=	
	{
		sector		= 	"dam",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "dam_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--COASTAL CITY
----------------------------------------------------------------
	coastal_city_hotel	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_shop	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1250,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_pearl	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_sea_terminal	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_brothel	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= { { force = MARAUDERS, value = 0.8 * Reputation.MAX, condition = MORE_OR_EQUAL } }
		},
		bonus		= 2500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_casino	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= { { force = MARAUDERS, value = 0.8 * Reputation.MAX, condition = MORE_OR_EQUAL } }
		},
		bonus		= 5000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_city_transport_net	=	
	{
		sector		= 	"coastal_city",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--PIRATE ISLAND
----------------------------------------------------------------
	pirate_island_tourism	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	pirate_island_villa	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	true,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	pirate_island_spa	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1750,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	pirate_island_houses	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	pirate_island_beach	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	pirate_island_boat	=	
	{
		sector		= 	"pirate_island",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= {},
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--MINES
----------------------------------------------------------------
	mines_new_mine	=	
	{
		sector		= 	"mines",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 5000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	mines_terminal	=	
	{
		sector		= 	"mines",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "trainstation" },
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 2000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	mines_equipment	=	
	{
		sector		= 	"mines",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--COASTAL FORTRESS
----------------------------------------------------------------
	coastal_fortress_fort	=	
	{
		sector		= 	"coastal_fortress",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	coastal_fortress_bus	=	
	{
		sector		= 	"coastal_fortress",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "coastal_fortress_fort" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 200,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--MOUNTAIN VILLAGE
----------------------------------------------------------------
	mountain_village_folk	=	
	{
		sector		= 	"mountain_village",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	mountain_village_tourism	=	
	{
		sector		= 	"mountain_village",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	mountain_village_shop	=	
	{
		sector		= 	"mountain_village",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= { "mountain_village_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 500,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--OUTPOST
----------------------------------------------------------------
	outpost_radar	=	
	{
		sector		= 	"outpost",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--BASE
----------------------------------------------------------------
	base_training	=	
	{
		sector		= 	"base",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--UN CAMP
----------------------------------------------------------------
	un_camp_social	=	
	{
		sector		= 	"un_camp",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = 	{ 
								{ force = UN, 			value = Reputation.Bonus.MEDIUM  },
								{ force = BUTSI, 		value = Reputation.Bonus.NOTMUCH },
								{ force = ARMY, 		value = Reputation.Penalty.SMALL },
								{ force = MARAUDERS,	value = Reputation.Penalty.TINY  },
								{ force = CIVILIANS, 	value = Reputation.Bonus.SMALL   }
							},
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	un_camp_bus	=	
	{
		sector		= 	"un_camp",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = 	{ 
								{ force = UN, 			value = Reputation.Bonus.SMALL  },
								{ force = BUTSI, 		value = Reputation.Bonus.TINY },
								{ force = ARMY, 		value = Reputation.Penalty.TINY },
								{ force = MARAUDERS,	value = Reputation.Penalty.TINY  },
								{ force = CIVILIANS, 	value = Reputation.Bonus.TINY   }
							},
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
	un_camp_chopper	=	
	{
		sector		= 	"un_camp",
		available	=	false,
		bought		=	false,
		sellable	= 	true,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= nil,
			Upgrades	= nil,
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 0,
		reputation_bonus = 	{ 
								{ force = UN, 			value = Reputation.Bonus.SMALL   },
								{ force = BUTSI, 		value = Reputation.Bonus.SMALL   },
								{ force = ARMY, 		value = Reputation.Penalty.SMALL },
								{ force = MARAUDERS,	value = Reputation.Penalty.SMALL },
								{ force = CIVILIANS, 	value = Reputation.Bonus.SMALL   }
							},
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
----------------------------------------------------------------
--NORTH BASE
----------------------------------------------------------------
	north_base_tourism	=	
	{
		sector		= 	"north_base",
		available	=	false,
		bought		=	false,
		sellable	= 	false,
		militia		=	nil,
		Dependencies	=
		{
			Sectors		= { "pirate_island" },
			Upgrades	= { "pirate_island_tourism" },
			Vars		= nil,
			Reputation 	= nil
		},
		bonus		= 1000,
		reputation_bonus = nil,
--		onBuy = function(s) end,
--		onSell = function(s) end
	},
}
--
function fillMilitiaUpgrades()
	
	local fill = function(sector, data)
		
		local each = function(template, data)

			local mu = sector.."_"..template
			
			Upgrades[mu] = {}
			Upgrades[mu].sector 			=	sector
			Upgrades[mu].available			=	false
			Upgrades[mu].bought				=	false
			Upgrades[mu].sellable			=	true
			Upgrades[mu].militia			=	data.militia
			Upgrades[mu].bonus				=	data.bonus
			Upgrades[mu].reputation_bonus 	=	deepcopy(data.reputation_bonus)
			Upgrades[mu].Dependencies		= 	deepcopy(data.Dependencies)
--			Upgrades[mu].onBuy				=	deepcopy(data.onBuy)
--			Upgrades[mu].onSell				= 	deepcopy(data.onSell)
--			Upgrades[mu].onBuy 				=	function(s, u)
--													buyMilitia(s, u)
--												end
--			Upgrades[mu].onSell 			=	function(s, u)
--													setMilitia(s, tonumber(getGVAR(u.."_slot")), "", 0)
--												end

			--log("test_u1", sector, template, mu, Upgrades[mu].sector)
		end
		
		table.foreach(MilitiaTemplates, each)
	end

	table.foreach(Sectors, fill)
	
--	local check = function(upgrade, info)
--		if (info.militia ~= nil) then
--			if (info.Dependencies.Reputation ~= nil) then
--				log("test_u1a", upgrade, info.Dependencies.Reputation[1])
--			end
--		end
--	end
	
--	table.foreach(Upgrades, check)
end
--
function updateUpgrades(sector)
	local u = deepcopy(Upgrades)
	--
	local update = function(upgrade, info)
		local res = checkIfUpgradeAvailable(info.sector, upgrade)
		Upgrades[upgrade].available = res
	end
	--
	table.foreach(u, update)
end
--
function eventIsUpgradeAvailable(sector, upgrade)
	if ( Upgrades[upgrade].bought == true ) then
		return false
	end	
	--
	if ( Upgrades[upgrade].militia ~= nil ) then
		local hasSlots = false
		
		for slot = 1, 4, 1 do
			local mt, mc = getMilitia(sector, slot)
			if ( mc == 0 ) then
				hasSlots = true
				break
			end
		end
		
		if ( hasSlots == false ) then
			return false
		end
	end		
	--
	return checkIfUpgradeAvailable(sector, upgrade)
end
--
function eventUpgradeSell(sector, upgrade)
	if (Upgrades[upgrade].militia ~= nil) then
		setMilitia(sector, tonumber(getGVAR(upgrade.."_slot")), "", 0)
	end
	
	--Upgrades[upgrade].onSell(sector, upgrade)
	Upgrades[upgrade].bought = false

	updateUpgrades(sector)
end
--
function eventUpgradeBuy(sector, upgrade)

		local u = deepcopy(Upgrades[upgrade])
		local log_id = "upgrades_dynamic"
		
		log(log_id, "Upgrade bought:", upgrade)
		
		if (u.reputation_bonus ~= nil) then
			
			log(log_id, "Upgrade has reputation bonuses/penalties")
			
			local adjust = function(index, data)
				log(log_id, "Adjusting reputation with", data.force, "by", data.value)
				addReputation(data.force, data.value)
			end
			
			table.foreach(u.reputation_bonus, adjust)

		end
				
		if (Upgrades[upgrade].militia ~= nil) then
			buyMilitia(sector, upgrade)
		end

		--Upgrades[upgrade].onBuy(sector, upgrade)
		Upgrades[upgrade].bought = true

		updateUpgrades(sector)
end
--
function checkIfUpgradeAvailable(sector, upgrade)
	local log_id = "check_upgrade"
	
	log(log_id, "===================================")
	log(log_id, "ENTRANCE")
	
	local res = true
	--
	if ((upgrade ~= nil) and (Upgrades[upgrade] ~= nil)) then
		log(log_id, ">","--------------------------------")
		log(log_id, ">","Upgrade:", upgrade)
		log(log_id, ">","--------------------------------")

		local info = deepcopy(Upgrades[upgrade])
		local owner = Sectors[sector].owner
		
		--log("test_u2", upgrade, sector, owner)
		
		if (
				(owner ~= CURRENT_ALLY)
				and
				(owner ~= PLAYER)
				and 
				(
					(Forces[owner][PLAYER] ~= ALLY)
					or
					(
						(owner == UN)
						and 
						(Forces[UN][PLAYER] == ENEMY)
					)
				)
			) then

			res = false

			log(log_id, ">>>","Sector owner failed:", owner)
		end
		
		if (res == true) then
			log(log_id, ">>>","Sector owner passed")

			if (info.Dependencies.Upgrades ~= nil) then
				log(log_id, ">>>","Has upgrades dependancy")
				--
				local check_upg_dep = function(index, iupgrade)
					local iu = iupgrade
					if ( info.militia ~= nil ) then
						iu = info.sector.."_"..iupgrade
					end
					if ( Upgrades[iu].bought == false ) then
						log(log_id, ">>>","Upgrades dependancy failed:", iu)
						res = false
					end
				end
				--
				table.foreach(info.Dependencies.Upgrades, check_upg_dep)
			end
			--
			if (res == true) then
				log(log_id, ">>>","Upgrades dependancy passed")
				if (info.Dependencies.Vars ~= nil) then
					log(log_id, ">>>","Has vars dependancy")
					local check_var_dep = function(var, value)
						if (getGVAR(var) ~= value) then
							log(log_id, ">>>","Vars dependancy failed:", var)
							res = false
						end
					end
					--
					table.foreach(info.Dependencies.Vars, check_var_dep)
				end
				--
				if (res == true) then
					log(log_id, ">>>","Vars dependancy passed")
					if (info.Dependencies.Sectors ~= nil) then
						log(log_id, ">>>","Has sectors dependancy")
						local check_sec_dep = function(index, sector)
							local owner = Sectors[sector].owner
							if ((owner ~= PLAYER) and (owner ~= CURRENT_ALLY) and (Forces[owner][PLAYER] ~= ALLY)) then
								log(log_id, ">>>","Sectors dependancy failed:", sector)
								res = false
							end
						end
						--
						table.foreach(info.Dependencies.Sectors, check_sec_dep)
					end
					--
					if (res == true) then
						log(log_id, ">>>","Sectors dependancy passed")
						if (info.Dependencies.Reputation ~= nil) then
							log(log_id, ">>>","Has reputation dependancy")
							local check_rep_dep = function(index, data)
								local rep = Reputation[data.force]
								local con = data.condition
								local val = data.value
								
								if (con == EQUAL) then
									if (rep ~= val) then
										res = false
									end
								elseif (con == MORE_OR_EQUAL) then
									if (rep <= val) then
										res = false
									end
								elseif (con == LESS_OR_EQUAL) then
									if (rep >= val) then
										res = false
									end
								elseif (con == MORE) then
									if (rep < val) then
										res = false
									end
								elseif (con == LESS) then
									if (rep > val) then
										res = false
									end
								elseif (con == NOT_EQUAL) then
									if (rep == val) then
										res = false
									end
								end

								if (info.militia ~= nil) then
									res = (Forces[data.force][PLAYER] == ALLY)
								end

								if (res == false) then
									log(log_id, ">>>","Reputation dependancy failed:", data.force)
								end
								
							end
							--
							table.foreach(info.Dependencies.Reputation, check_rep_dep)
						end
						--
						if (res == true) then
							log(log_id, ">>>","Reputation dependancy passed")
						end
						--
					end
				end
			end
		end
	else
		return false
	end
	--
	log(log_id, "EXIT")
	log(log_id, "===================================")
	--
	return res
end
